/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UIObjectsPropertyLabelKeys;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.ui.bonsai.config.AbstractNodeConfigBean;
import com.ibm.hwmca.ui.bonsai.config.UIInfoConfigBean;
import com.ibm.hwmca.ui.bonsai.earth.TreeNodeIdManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BonsaiTreeNode {
    protected static final List DEFAULT_COLUMN_TYPES = new ArrayList(2);
    private final Object CHILDREN_LOCK_OBJECT = new Object();
    private String id;
    private String workArea;
    private boolean uriWorkArea;
    private UIInfo uIInfo;
    private BonsaiTreeNode parent;
    private List children;
    private AbstractNodeConfigBean configBean;

    protected BonsaiTreeNode(BonsaiTreeNode clonee, BonsaiTreeNode parent) {
        this.registerId();
        this.workArea = clonee.workArea;
        this.uriWorkArea = clonee.uriWorkArea;
        this.uIInfo = clonee.uIInfo;
        this.configBean = clonee.configBean;
        this.parent = parent;
        this.children = new ArrayList();
    }

    public BonsaiTreeNode() {
        this.registerId();
        this.children = new ArrayList();
    }

    public BonsaiTreeNode(AbstractNodeConfigBean configBean, BonsaiTreeNode parent) {
        this.registerId();
        this.configBean = configBean;
        this.workArea = configBean.getWorkArea();
        this.uriWorkArea = configBean.isWorkAreaType("uri");
        this.parent = parent;
        this.children = new ArrayList();
        UIInfoConfigBean uIConfigBean = configBean.getUIInfo();
        if (uIConfigBean != null) {
            String bundle = uIConfigBean.getResourceBundle();
            LocalizableText name = new LocalizableText(bundle, uIConfigBean.getName());
            LocalizableText caption = new LocalizableText(bundle, uIConfigBean.getCaption());
            String image = uIConfigBean.getImageName();
            this.uIInfo = image == null ? new UIInfo(name, caption) : new UIInfo(name, caption, uIConfigBean.getImagePath() + image);
        }
    }

    public String getId() {
        return this.id;
    }

    private void registerId() {
        TreeNodeIdManager idManager = TreeNodeIdManager.getTreeNodeIdManager();
        if (this.id != null) {
            idManager.remove(this.id);
        }
        this.id = idManager.add(this);
    }

    private void deregisterId() {
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            ((BonsaiTreeNode)i.next()).deregisterId();
        }
        TreeNodeIdManager.getTreeNodeIdManager().remove(this.id);
    }

    public String getXMLKey() {
        return this.configBean.getKey();
    }

    public BonsaiTreeNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(BonsaiTreeNode childNode) {
        Object object = this.CHILDREN_LOCK_OBJECT;
        synchronized (object) {
            this.children.add(childNode);
        }
    }

    public void addChildren(BonsaiTreeNode[] childNodes) {
        for (int i = 0; i < childNodes.length; ++i) {
            this.addChild(childNodes[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(String id) {
        Object object = this.CHILDREN_LOCK_OBJECT;
        synchronized (object) {
            BonsaiTreeNode child = null;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                child = (BonsaiTreeNode)iterator.next();
                if (!child.getId().equals(id)) continue;
                child.deregisterId();
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllChildren() {
        Object object = this.CHILDREN_LOCK_OBJECT;
        synchronized (object) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                ((BonsaiTreeNode)i.next()).deregisterId();
            }
            this.children = new ArrayList();
        }
    }

    public List getChildren() {
        return this.children;
    }

    public String getWorkArea() {
        return this.workArea;
    }

    public boolean isUriWorkArea() {
        return this.uriWorkArea;
    }

    public UIInfo getUIInfo() {
        return this.uIInfo;
    }

    public List getColumnTypes() {
        return DEFAULT_COLUMN_TYPES;
    }

    public List getColumnHeaders(Locale locale) {
        ArrayList<String> headers = new ArrayList<String>(DEFAULT_COLUMN_TYPES.size());
        CommonResourceBundle bundle = new CommonResourceBundle(locale);
        Iterator i = this.getColumnTypes().iterator();
        while (i.hasNext()) {
            headers.add(bundle.getString(UIObjectsPropertyLabelKeys.getPropertyLabelKey((String)i.next())));
        }
        return headers;
    }

    public Map getColumnValues(Locale locale) {
        UIInfo uiInfo = this.getUIInfo();
        HashMap values = new HashMap(2);
        values.put(DEFAULT_COLUMN_TYPES.get(0), uiInfo.getName(locale));
        values.put(DEFAULT_COLUMN_TYPES.get(1), uiInfo.getCaption(locale));
        return values;
    }

    public boolean isPermitted(Set userRoles) {
        return true;
    }

    public boolean isShown(String modelKey, UISession session) {
        return true;
    }

    public AbstractNodeConfigBean getConfigBean() {
        return this.configBean;
    }

    public BonsaiTreeNode createViewNode(BonsaiTreeNode parent) {
        BonsaiTreeNode view = new BonsaiTreeNode(this, parent);
        view.copyChildren(this);
        return view;
    }

    protected void copyChildren(BonsaiTreeNode clonee) {
        Iterator i = clonee.children.iterator();
        while (i.hasNext()) {
            this.addChild(((BonsaiTreeNode)i.next()).createViewNode(this));
        }
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            return this.id.equals(((BonsaiTreeNode)obj).getId());
        }
        catch (ClassCastException ccEx) {
            return false;
        }
    }

    public int hashCode() {
        return Integer.decode("0x" + this.id);
    }

    public String toString() {
        return this.getXMLKey() + " (" + this.getId() + ")";
    }

    public String toDebugString() {
        return "BonsaiTreeNode{, id='" + this.id + "'" + ", workArea='" + this.workArea + "'" + ", uriWorkArea=" + this.uriWorkArea + "}";
    }

    static {
        DEFAULT_COLUMN_TYPES.add("Name");
        DEFAULT_COLUMN_TYPES.add("Caption");
    }
}

